var geoPlugin = {};

geoPlugin.init = function() {
    /* geolocation is available */
    console.log("1");
    if (navigator.geolocation) {
        var options = {timeout:30000};
        navigator.geolocation.getCurrentPosition(geoPlugin.successHandler, geoPlugin.errorHandler, options);
        //var watchID = navigator.geolocation.watchPosition(geoPlugin.successHandler, geoPlugin.errorHandler, options);
    } else {
        console.log('Geolocation is not supported by this browser.');
    }
};


geoPlugin.successHandler = function(position) {
console.log(position);
    var lat = position.coords.latitude;
    var lon = position.coords.longitude;
   
    var posjson = {};
    posjson.lat = lat;
    posjson.long = lon;
    
    console.log(lat+"  "+lon);

//    $.jStorage.set("CURRENT_POSITION", posjson);
    $.jStorage.set("current_lat", lat);
    $.jStorage.set("current_lng", lon);
    
       uc.nearMe();

    $.jStorage.deleteKey("geoError");
};

geoPlugin.errorHandler = function(error) {
    console.log(JSON.stringify(error));
    //$.bootbar.danger("<b class='glyphicon glyphicon-exclamation-sign'></b> Unable to load the Current Position", { autoDismiss: true, dismissTimeout:2000 });
    $('.nearMePanel').empty(); // TODO
    var msg = '';
    switch (error.code) {
    case error.PERMISSION_DENIED:
        console.log("User denied the request for Geolocation.");
        msg = 'User denied the request for Geolocation';
        break;
    case error.POSITION_UNAVAILABLE:
        console.log("Location information is unavailable.");
        msg = 'Location information is unavailable';
        break;
    case error.TIMEOUT:
        console.log("The request to get user location timed out.");
        msg = 'The request to get user location timed out';
        break;
    case error.UNKNOWN_ERROR:
        console.log("An unknown error occurred.");
        msg = 'An unknown error occurred';
        break;
    }

    $.jStorage.set("geoError", msg);
};