var analysisMAP = {};
analysisMAP.data = '';
analysisMAP.layoutConfig = null;



analysisMAP.initialise = function () {

    //analysisMAP.map.remove();
    //    analysisMAP.map.off();

    var current_user = $.jStorage.get("userObject").userName;
    //console.log("USER....." + current_user);
    /* Constants */
    analysisMAP.map = null;
    //analysisMAP._lat = 19;
    // analysisMAP._lng = 17;
    var D = "diouser";
    var S = "siouser";

    //console.log(analysisMAP.getCurrentUserConfigLayout());

    if (current_user == "diouser1") {
        //console.log("I am Dio");
        analysisMAP._lat = 10.8505;
        analysisMAP._lng = 76.2711;
        analysisMAP._zoom = 7;
    } else if (current_user == current_user) {
        //console.log("I am Sio");
        var current_userobj = $.jStorage.get("userObject");
        analysisMAP._lat = Number(current_userobj.latitude);
        analysisMAP._lng = Number(current_userobj.longitude);
        //console.log(analysisMAP._lat);
        //console.log(analysisMAP._lng);
        //        analysisMAP._lat = 10.8505;
        //        analysisMAP._lng = 76.2711;
        analysisMAP._zoom = 5;
    } else {
        console.log("I am Nio");
        analysisMAP._lat = 22.9734;
        analysisMAP._lng = 78.6569;
        analysisMAP._zoom = 4;

    }


    analysisMAP._minZoom = 4;
    analysisMAP._maxZoom = 20;
    analysisMAP.ggl;
    analysisMAP.check = true;
    analysisMAP.geoJsonLayer = null;
    analysisMAP.geoJsonHolder = null;
    $(".provDistlevel").hide();
    analysisMAP.initialiseMap(); // Initialise the map
    analysisMAP.loadWorldGeoJson(); // Load world shape file
};





analysisMAP.getCurrentUserConfigLayout = function () {
    // console.log("1");
    var current_user = $.jStorage.get("userObject");

    var config = {

        userRole: null,
        userName: null,
        countryName: null,
        stateName: null,
        districtName: null,
        shapeFileUrl: null
    };

    if (current_user.userRole === "DIO") {
        config.userRole = current_user.userRole;
        config.userName = current_user.userName;
        config.countryName = 'India';
        config.stateName = current_user.orgParentName;
        config.districtName = current_user.orgName;
        config.shapeFileUrl = './shapes/country/india/state/' + config.stateName.toLowerCase() + '/district/' + config.districtName.toLowerCase() + ".geojson";

    } else if (current_user.userRole === "SO") {
        config.userRole = current_user.userRole;
        config.userName = current_user.userName;
        config.countryName = current_user.orgParentName;
        config.stateName = current_user.orgName;
        console.log(config.stateName);
        config.districtName = null;
        config.shapeFileUrl = './shapes/country/india/state/' + config.stateName.toLowerCase() + '/' + config.stateName.toLowerCase() + ".geojson";

        map.stateName = current_user.orgName;
        map.shapeFileUrl = './shapes/country/india/state/' + config.stateName.toLowerCase() + '/' + config.stateName.toLowerCase() + ".geojson";

    } else if (current_user.userRole === "NO") {
        config.userRole = current_user.userRole;
        config.userName = current_user.userName;
        config.countryName = current_user.orgName;
        config.stateName = null;
        config.districtName = null;
        config.shapeFileUrl = './shapes/country/india/District.geojson';
        config.shapeFileUrl1 = './shapes/country/india/IND.geojson';
    }

    return config;
}



// Initialise the map
analysisMAP.initialiseMap = function () {
    analysisMAP.map = null;
    $("#impactPreventionMapA").empty();
    console.log(analysisMAP.map);


    analysisMAP.map = new L.Map('impactPreventionMapA', {
        attributionControl: false,
        center: new L.LatLng(analysisMAP._lat, analysisMAP._lng),
        zoom: analysisMAP._zoom,
        minZoom: analysisMAP._minZoom,
        maxZoom: analysisMAP._maxZoom,
        doubleClickZoom: false,
        scrollWheelZoom: false,
        zoomControl: false
    });

    //analysisMAP.loadMapTiles(); // Load map tiles
    //    analysisMAP.initialiseMapMenuControl(); // Re-initialise map controls after adding on map
    //ADD RESET BUTTON 
    (function () {
        var control = new L.Control({
            position: 'topright'
        });
        control.onAdd = function (map) {
            var azoom = L.DomUtil.create('a', 'resetzoom');
            azoom.innerHTML = "<button id='resetbtn'>Back</button>";
            L.DomEvent
                .disableClickPropagation(azoom)
                .addListener(azoom, 'click', function () {
                    MapDrillUp();
                    //                    console.log("test1");
                    uc.loadRealTimeMapChart();
                    //analysisMAP.resetMap();
                    map.setView(map.options.center, map.options.zoom);
                }, azoom);
            return azoom;
        };
        return control;
    }())
    .addTo(analysisMAP.map);

    //ADD LEGEND CONTROL
    function getColor(d) {
        return d > 1000 ? '#800026' :
            d > 500 ? '#BD0026' :
            d > 200 ? '#E31A1C' :
            d > 100 ? '#FC4E2A' :
            d > 50 ? '#FD8D3C' :
            d > 20 ? '#FEB24C' :
            d > 10 ? '#FED976' :
            '#FFEDA0';
    }


    var legend = L.control({
        position: 'bottomright'
    });

    legend.onAdd = function (map) {

        var div = L.DomUtil.create('div', 'info legend'),
            grades = [0, 10, 20, 50, 100, 200, 500, 1000],
            labels = [];

        // loop through our density intervals and generate a label with a colored square for each interval
        div.innerHTML += '<h4> No data ' + ' - ' + ' <div style=" float: right;width: 20px;height: 20px;margin: 1px; border: 1px solid rgba(0, 0, 0, .2);background: #d3e7ff;"></div></h4>'
        for (var i = 0; i < grades.length; i++) {

            // div.innerHTML += '<i style="background:' + getColor(grades[i] + 1) + '"></i> ' +
            //  grades[i] + (grades[i + 1] ? '&ndash;' + grades[i + 1] + '<br>' : '+');

        }

        return div;
    };

    legend.addTo(analysisMAP.map);
    //END ADD LEGEND CONTROL


    new L.Control.Zoom({
        position: 'bottomright'
    }).addTo(analysisMAP.map);
};

// Load map tiles
analysisMAP.loadMapTiles = function () {
    // Google Layer
    analysisMAP.ggl = new L.Google();

    analysisMAP.baseMaps = {
        "Google Maps": analysisMAP.ggl
    };

    analysisMAP.map.addLayer(analysisMAP.ggl);
    analysisMAP.map.invalidateSize();
};

analysisMAP.applyStateborder = function () {
    var dureNational = {};
    var countryShapeWholeFilePath = './shapes/country/india/IND.geojson';
    $.getJSON(countryShapeWholeFilePath, function (geoJsondata) {

        if (geoJsondata != undefined) {
            dureNational.geoJsonWholeHolder = geoJsondata;
            //console.log(dureNational.geoJsonWholeHolder);

            dureNational.geoJsonWholeLayer = L.geoJson(dureNational.geoJsonWholeHolder, {
                filter: '',
                style: {
                    color: '#003da0',
                    weight: 0.6,
                    opacity: 1,
                    fillColor: '',
                    fillOpacity: 0
                },
                onEachFeature: ''
            });
            //console.log(dureNational.geoJsonWholeLayer);
            analysisMAP.map.addLayer(dureNational.geoJsonWholeLayer); //test load layer
        }
    }).error();


}


// Get World GEOJSON shape file
analysisMAP.loadWorldGeoJson = function () {






    if (analysisMAP.geoJsonHolder == undefined) {

        analysisMAP.layoutConfig = analysisMAP.getCurrentUserConfigLayout();
        var shapeFilePath = analysisMAP.layoutConfig.shapeFileUrl
        var shapeFilePath1 = analysisMAP.layoutConfig.shapeFileUrl1
            //console.log(shapeFilePath);
        $.getJSON(shapeFilePath, function (geoJsondata) {
            if (geoJsondata != undefined) {
                analysisMAP.geoJsonHolder = geoJsondata;
                if (analysisMAP.map == undefined) {
                    analysisMAP.initialiseMap();
                }
                analysisMAP.applyStateborder();
                analysisMAP.showIndicatorDataOnMap();
                $('#loading').hide();
            }
        }).error(function (jqXHR, textStatus, errorThrown) {

            console.log(jqXHR);
            console.log(textStatus);
            console.log(errorThrown);
        });


    } else {
        analysisMAP.showIndicatorDataOnMap();
        $('#loading').hide();
    }
};

analysisMAP.showIndicatorDataOnMap = function () {
    var layerFilter = analysisMAP.filterAttr('iso_a2', false, []);
    analysisMAP.loadlayer(layerFilter);
    //console.log(layerFilter);
    //alert("show indicator")
};

analysisMAP.filterAttr = function (baseKey, apply, container) {
    var layerFilter = {};
    layerFilter.baseKey = baseKey
    layerFilter.apply = apply;
    layerFilter.container = container;
    return layerFilter;
};


analysisMAP.loadlayer = function (layerFilter) {
    analysisMAP.totalArr = []
    analysisMAP.geoJsonLayer = L.geoJson(analysisMAP.geoJsonHolder, {
        filter: function (feature) {
            return analysisMAP.filterLayer(feature, layerFilter);
        },
        style: analysisMAP.setLayerStyle,
        onEachFeature: analysisMAP.setLayerFeature
    });
    analysisMAP.map.addLayer(analysisMAP.geoJsonLayer);


    //    analysisMAP.map.addLayer(dureNational.geoJsonWholeLayer); //test load layer

    setTimeout(function () {

        analysisMAP.map.fitBounds(analysisMAP.geoJsonLayer.getBounds());
    }, 1500);


};

analysisMAP.filterLayer = function (feature, layerFilter) {
    var returnFilter = true;
    if (layerFilter.apply) {
        var id = feature.properties[layerFilter.baseKey];
        returnFilter = analysisMAP.idParser(layerFilter.container, id);
    }
    return returnFilter;
};

analysisMAP.idParser = function (container, id) {
    var retCheck = false;
    for (var i in container) {
        if (container.hasOwnProperty(i)) {
            if (container[i] === id) {
                retCheck = true;
                break;
            }
        }
    }
    return retCheck;
};

analysisMAP.setLayerStyle = function (feature) {
    //console.log(feature);
    var name = feature.properties.NAME_2;
    console.log(name);
    if (name == undefined) {
        name = feature.properties.NAME_2;
    }

    var fillclr = analysisMAP.getFeatureFillClr(analysisMAP.getFeatureVal(name));

    //var classNam = 'highlight-' + fillclr.replace(new RegExp('#', 'g'), "");
    var classNam = '';

    if (analysisMAP.filterCatApp) {
        analysisMAP.setFilterCat(classNam, countryID)
    };
    return {
        color: '#FFF',
        weight: 0.8,
        opacity: 1,
        fillColor: fillclr,
        fillOpacity: 1,
        className: classNam
    };
};


analysisMAP.getFeatureVal = function (id) {
    //alert("test");
    //ux.selectedStatename = "";
    console.log(id);
    //var name = id.toUpperCase();
    data = analysisMAP.data({
        "5": {
            "isnocase": id
        }
    }).get();
    //console.log(data);
    //console.log(data.length);

    //console.log(id);
    //console.log(map.stateName);
    // console.log(analysisMAP.layoutConfig);
    //var returnVal = '#3ABA8B';
    var data = "";
    //    if (analysisMAP.layoutConfig.userRole == 'NO' && (id == 'Kerala' || id == 'Maharashtra')) {
    if (analysisMAP.layoutConfig.userRole == 'NO') {
        returnVal = '#d3e7ff'
    } else {
        var returnVal = '#b3b3ff';
        data = analysisMAP.data({
            "5": {
                "isnocase": id
            }
        }).get();
        //console.log(data.length);
    }

    var name = id;
    if (analysisMAP.layoutConfig.userRole == 'NO') {
        var data = analysisMAP.data({

            "5": {
                "isnocase": name
            }

        }).get();
        console.log(data);
        $.each(data, function (i, e) {
            //console.log(i);
            //console.log(e.state); //SET USERNAME FROM HERE FOR DRILLDOWN AND GRAPHS
            //ux.selectedStatename = e.state;
        });
        //console.log(data.length);
        if (data.length > 10) {
            //console.log("higher");
            analysisMAP.getFeatureFillClr('#D83C1A');
        }
    }


    if (data != undefined) {
        //console.log(data.length);
        //console.log(analysisMAP.layoutConfig);
        if (analysisMAP.layoutConfig.userRole == 'SO' && data.length == 0) {
            var returnVal = '#fee5d9';
        }
    }

    if ($.isEmptyObject(data) == false) {
        // $.each(data, function (i, e) {
        returnVal = '#0349ba';
        //console.log(returnVal);
        //            if (e.district != '') {
        //                console.log(e.district);
        //                returnColor = '#000000';
        //            }

        // });
    }
    // returnColor = '#ffffff';
    return returnVal;
};

analysisMAP.getFeatureFillClr = function (value) {

    var returnColor = '';
    returnColor = value;
    //console.log(value);
    if (typeof returnColor == 'undefined') {
        returnColor = '#EB2E17';
    }
    return returnColor;
};

analysisMAP.setFilterCat = function (classNam, id) {
    if (!analysisMAP.filterCat.hasOwnProperty(classNam)) {
        analysisMAP.filterCat[classNam] = [];
    }
    analysisMAP.filterCat[classNam].push(id);
};

analysisMAP.removeLayer = function () {
    if (analysisMAP.geoJsonLayer != undefined) {
        analysisMAP.map.removeLayer(analysisMAP.geoJsonLayer);
    }
};

analysisMAP.setLayerFeature = function (feature, layer) {

    layer.on({
        mouseover: analysisMAP.highlightFeature,
        mouseout: analysisMAP.resetFeature
    });

    $(layer).click(function (e) {
        //console.log(e);
        var NAME_2 = e.target.feature.properties.DISTRICT;
        var stateName = e.target.feature.properties.NAME;

        //console.log(NAME_2);
        NAME_2 = NAME_2;
        var data = analysisMAP.data({
            5: NAME_2
        }).get();
        //console.log(data);
        //console.log(data.length);

        var datanew = analysisMAP.data({
            6: stateName

        }).get();
        //console.log(datanew);
        $.each(datanew, function (i, e) {
            //console.log(i);
            //console.log(e.state);
            ux.selectedStatename = e.state;
        });



    }).dblclick(function (e) {

        $(this).data('double', 2);
        //console.log(e.target.feature.properties);
        //console.log(e.target.feature.properties.ISO);
        //console.log(e.target.feature.properties.NAME);
        map.stateName = e.target.feature.properties.NAME;
        if (e.target.feature.properties.ISO == e.target.feature.properties.ISO) {
            e.target.unbindLabel();

            //console.log(ux.selectedStatename);
            uc.drillMapChangechartdata(ux.selectedStatename);
            MapDrilldown();

        }
    });

    layer.bindLabel(analysisMAP.getLabelContent(layer), {
        dynamicBorderColor: 'rgba(240, 243, 246, 0.58)',
        direction: 'right',
        //offset:[6, -6],
        opacity: 0.9
            //noHide: true
    });
};

analysisMAP.highlightFeature = function (e) {
    var layer = e.target;

    layer.setStyle({
        weight: 2,
        color: 'white',
        dashArray: '',
        fillOpacity: 0.8
    });


};

analysisMAP.capitalizeFirstLetter = function (string) {
    // console.log(string);
    var name = string.charAt(0).toUpperCase() + string.slice(1);
    //console.log(name);
    return name;

}
analysisMAP.totalArr = [];
analysisMAP.getLabelContent = function (layer) {

    var layerStyle = analysisMAP.getLayerStyle(layer);
    //analysisMAP.legendControlObj.highLightScale(layerStyle.className, layerStyle.fillColor, 'bold', '10px');
    analysisMAP.labelBorderClr = layerStyle.fillColor;

    name1 = layer.feature.properties.NAME_2
    console.log(layer);

    //    var name = layer.feature.properties.NAME;
    var name = layer.feature.properties.NAME_2;

    if (name == undefined) {
        name = layer.feature.properties.NAME_2
    }
    //console.log(name);
    analysisMAP.capitalizeFirstLetter(name);
    //console.log(name);
    //name = name.toUpperCase();
    //console.log(layer.feature.properties.DISTRICT);

    if (analysisMAP.layoutConfig.userRole == 'NO') {
        var data = analysisMAP.data({
            "5": {
                "isnocase": name
            }

        }).get();
        //console.log(data);
        console.log(data.length);
        var len = Number(data.length)
        console.log(len, data);

        if (data.length > 1) {

            analysisMAP.totalArr.push(len);
            console.log(analysisMAP.totalArr);
            var sum = analysisMAP.totalArr.reduce((x, y) => x + y);
            console.log(sum);

            analysisMAP.sum = sum
                //            $("#totalcasedispyr1").html(analysisMAP.sum);
            analysisMAP.getFeatureFillClr('#D83C1A');
        }
    } else {

        var data = analysisMAP.data({
            5: name

        }).get();
        //console.log(data.length);



    }

    console.log(analysisMAP.sum);
    var sum = analysisMAP.totalArr.reduce((a, b) => a + b, 0);
    console.log(sum); // 6
    // console.log(data.length);

    var html = '';

    // $.each(data, function (i, e) {
    //console.log(data);
    //console.log(data[0].district);
    //var dis=e.district;
    var count = data.length
        //console.log(count);
    var districtName = layer.feature.properties.NAME; //data.length != 0 ? data[0].district : layer.feature.properties.NAME;
    //console.log(districtName);
    if (districtName == undefined) {
        districtName = layer.feature.properties.NAME_2;
    }

    if (analysisMAP.layoutConfig.userRole == 'NO') {
        // && districtName == 'Kerala') {
        //console.log(data.length);
        var districtCount = data.length != 0 ? data.length : 'No case found';

    } else {
        var districtCount = data.length != 0 ? data.length : 'No case found';
    }
    //console.log(districtCount);
    if (districtCount > 10) {
        // console.log(districtCount);
        analysisMAP.getFeatureFillClr('#D83C1A');
    }

    html += '<div class="panel panel-info" style="z-index:9999 !important;">' +
        '<div class="panel-heading" style="background-color: #000; color:#fff;padding:0px 2px;"><h4 class="panel-title">' + "District : " + districtName + '</h4>' + '<br>' + "No. of cases : " + districtCount + '</div>' +
        '</div>';
    $("#totalcasedispyr1").html("  " + "    " + analysisMAP.sum);
    var caseCountTemplate = "<span class='labelpopup'><h3>" + districtName + "</h3><hr><span>Number of Cases: " + districtCount + "</span></span>";
    html = caseCountTemplate; //analysisMAP.buildHoverPopupHtml(districtName,caseCountTemplate);
    //console.log(html);
    return html;

    // });


    if ($.isEmptyObject(data) == false) {
        return html;
    }

};

analysisMAP.buildHoverPopupHtml = function (header, data) {

    var html = '<div class="box box-primary box-solid box-transparent">' +
        '<div class="box-header" data-toggle="tooltip" title="" data-original-title="Header tooltip">' +
        '<h4 class="box-title" >' + header + '</h4>' +
        '</div>' +
        '<div class="box-body">' + data +
        '</div>' +
        '</div>';

    return html;
}


analysisMAP.resetFeature = function (e) {
    var layerStyle = analysisMAP.getLayerStyle(e.target);
    analysisMAP.geoJsonLayer.resetStyle(e.target);
};


analysisMAP.getLayerStyle = function (layer) {
    var layerStyleObj = {};
    if (layer.options != undefined) {
        layerStyleObj.className = layer.options.className;
        layerStyleObj.fillColor = layer.options.fillColor;
    } else {
        var getLeafletId = layer._leaflet_id;
        var ftrlayer = layer._layers;
        layerStyleObj.className = ftrlayer[getLeafletId - 1].options.className;
        layerStyleObj.fillColor = ftrlayer[getLeafletId - 1].options.fillColor;
    }
    //console.log(layerStyleObj);
    return layerStyleObj;
};

analysisMAP.resetMap = function () {
    analysisMAP.removeLayer();
    analysisMAP.map.setView(new L.LatLng(analysisMAP._lat, analysisMAP._lng), analysisMAP._zoom);
    analysisMAP.loadWorldGeoJson();
};