var impactMAP = {};
impactMAP.data = '';
impactMAP.layoutConfig = null;


impactMAP.initialise = function () {

    //impactMAP.map.remove();
    //    impactMAP.map.off();

    var current_user = $.jStorage.get("userObject").userName;
    //console.log("USER....." + current_user);
    /* Constants */
    impactMAP.map = null;
    //impactMAP._lat = 19;
    // impactMAP._lng = 17;
    var D = "diouser";
    var S = "siouser";

    //console.log(impactMAP.getCurrentUserConfigLayout());

    if (current_user == "diouser1") {
        //console.log("I am Dio");
        impactMAP._lat = 10.8505;
        impactMAP._lng = 76.2711;
        impactMAP._zoom = 7;
    } else if (current_user == current_user) {
        //console.log("I am Sio");
        var current_userobj = $.jStorage.get("userObject");
        impactMAP._lat = Number(current_userobj.latitude);
        impactMAP._lng = Number(current_userobj.longitude);
        //console.log(impactMAP._lat);
        //console.log(impactMAP._lng);
        //        impactMAP._lat = 10.8505;
        //        impactMAP._lng = 76.2711;
        impactMAP._zoom = 5;
    } else {
        //console.log("I am Nio");
        impactMAP._lat = 22.9734;
        impactMAP._lng = 78.6569;
        impactMAP._zoom = 4;

    }


    impactMAP._minZoom = 4;
    impactMAP._maxZoom = 20;
    impactMAP.ggl;
    impactMAP.check = true;
    impactMAP.geoJsonLayer = null;
    impactMAP.geoJsonHolder = null;
    $(".provDistlevel").hide();
    impactMAP.initialiseMap(); // Initialise the map
    impactMAP.loadWorldGeoJson(); // Load world shape file
};





impactMAP.getCurrentUserConfigLayout = function () {
    // console.log("1");
    var current_user = $.jStorage.get("userObject");

    var config = {

        userRole: null,
        userName: null,
        countryName: null,
        stateName: null,
        districtName: null,
        shapeFileUrl: null
    };

    if (current_user.userRole === "DIO") {
        config.userRole = current_user.userRole;
        config.userName = current_user.userName;
        config.countryName = 'India';
        config.stateName = current_user.orgParentName;
        config.districtName = current_user.orgName;
        config.shapeFileUrl = './shapes/country/india/state/' + config.stateName.toLowerCase() + '/district/' + config.districtName.toLowerCase() + ".geojson";

    } else if (current_user.userRole === "SO") {
        config.userRole = current_user.userRole;
        config.userName = current_user.userName;
        config.countryName = current_user.orgParentName;
        config.stateName = current_user.orgName;
        //console.log(config.stateName);
        config.districtName = null;
        config.shapeFileUrl = './shapes/country/india/state/' + config.stateName.toLowerCase() + '/' + config.stateName.toLowerCase() + ".geojson";

        map.stateName = current_user.orgName;
        map.shapeFileUrl = './shapes/country/india/state/' + config.stateName.toLowerCase() + '/' + config.stateName.toLowerCase() + ".geojson";

    } else if (current_user.userRole === "NO") {
        config.userRole = current_user.userRole;
        config.userName = current_user.userName;
        config.countryName = current_user.orgName;
        config.stateName = null;
        config.districtName = null;
        config.shapeFileUrl = './shapes/country/india/District.geojson';
    }

    return config;
}



// Initialise the map
impactMAP.initialiseMap = function () {
    impactMAP.map = null;
    $("#impactPreventionMapB").empty();

    impactMAP.map = new L.Map('impactPreventionMapB', {
        attributionControl: false,
        center: new L.LatLng(impactMAP._lat, impactMAP._lng),
        zoom: impactMAP._zoom,
        minZoom: impactMAP._minZoom,
        maxZoom: impactMAP._maxZoom,
        doubleClickZoom: false,
        scrollWheelZoom: false,
        zoomControl: false
    });

    //impactMAP.loadMapTiles(); // Load map tiles
    //    impactMAP.initialiseMapMenuControl(); // Re-initialise map controls after adding on map
    //ADD RESET BUTTON 
    (function () {
        var control = new L.Control({
            position: 'topright'
        });
        control.onAdd = function (map) {
            var azoom = L.DomUtil.create('a', 'resetzoom');
            azoom.innerHTML = "<button id='resetbtn'>Back</button>";
            L.DomEvent
                .disableClickPropagation(azoom)
                .addListener(azoom, 'click', function () {
                    MapDrillUp();
                    //                    console.log("test1");
                    uc.loadRealTimeMapChart();
                    //impactMAP.resetMap();
                    map.setView(map.options.center, map.options.zoom);
                }, azoom);
            return azoom;
        };
        return control;
    }())
    .addTo(impactMAP.map);

    //ADD LEGEND CONTROL
    function getColor(d) {
        return d > 1000 ? '#800026' :
            d > 500 ? '#BD0026' :
            d > 200 ? '#E31A1C' :
            d > 100 ? '#FC4E2A' :
            d > 50 ? '#FD8D3C' :
            d > 20 ? '#FEB24C' :
            d > 10 ? '#FED976' :
            '#FFEDA0';
    }


    var legend = L.control({
        position: 'bottomright'
    });

    legend.onAdd = function (map) {

        var div = L.DomUtil.create('div', 'info legend'),
            grades = [0, 10, 20, 50, 100, 200, 500, 1000],
            labels = [];

        // loop through our density intervals and generate a label with a colored square for each interval
        div.innerHTML += '<h4> No data ' + ' - ' + ' <div style=" float: right;width: 20px;height: 20px;margin: 1px; border: 1px solid rgba(0, 0, 0, .2);background: #d3e7ff;"></div></h4>'
        for (var i = 0; i < grades.length; i++) {

            // div.innerHTML += '<i style="background:' + getColor(grades[i] + 1) + '"></i> ' +
            //  grades[i] + (grades[i + 1] ? '&ndash;' + grades[i + 1] + '<br>' : '+');

        }

        return div;
    };

    legend.addTo(impactMAP.map);
    //END ADD LEGEND CONTROL


    new L.Control.Zoom({
        position: 'bottomright'
    }).addTo(impactMAP.map);
};

// Load map tiles
impactMAP.loadMapTiles = function () {
    // Google Layer
    impactMAP.ggl = new L.Google();

    impactMAP.baseMaps = {
        "Google Maps": impactMAP.ggl
    };

    impactMAP.map.addLayer(impactMAP.ggl);
    impactMAP.map.invalidateSize();
};

impactMAP.applyStateborder = function () {
    var dureNational = {};
    var countryShapeWholeFilePath = './shapes/country/india/IND.geojson';
    $.getJSON(countryShapeWholeFilePath, function (geoJsondata) {

        if (geoJsondata != undefined) {
            dureNational.geoJsonWholeHoldernew = geoJsondata;
            //console.log(dureNational.geoJsonWholeHoldernew);

            dureNational.geoJsonWholeLayer1 = L.geoJson(dureNational.geoJsonWholeHoldernew, {
                filter: '',
                style: {
                    color: '#003da0',
                    weight: 0.6,
                    opacity: 1,
                    fillColor: '',
                    fillOpacity: 0
                },
                onEachFeature: ''
            });
            //console.log(dureNational.geoJsonWholeLayer1);
            impactMAP.map.addLayer(dureNational.geoJsonWholeLayer1); //test load layer
        }
    }).error();


}


// Get World GEOJSON shape file
impactMAP.loadWorldGeoJson = function () {

    if (impactMAP.geoJsonHolder == undefined) {

        impactMAP.layoutConfig = impactMAP.getCurrentUserConfigLayout();
        var shapeFilePath = impactMAP.layoutConfig.shapeFileUrl
            //console.log(shapeFilePath);
        $.getJSON(shapeFilePath, function (geoJsondata) {
            if (geoJsondata != undefined) {
                impactMAP.geoJsonHolder = geoJsondata;
                if (impactMAP.map == undefined) {
                    impactMAP.initialiseMap();
                }
                impactMAP.applyStateborder();
                impactMAP.showIndicatorDataOnMap();
                $('#loading').hide();
            }
        }).error(function (jqXHR, textStatus, errorThrown) {

            console.log(jqXHR);
            console.log(textStatus);
            console.log(errorThrown);
        });
    } else {
        impactMAP.showIndicatorDataOnMap();
        $('#loading').hide();
    }
};

impactMAP.showIndicatorDataOnMap = function () {
    var layerFilter = impactMAP.filterAttr('iso_a2', false, []);
    impactMAP.loadlayer(layerFilter);
    //console.log(layerFilter);
    //alert("show indicator")
};

impactMAP.filterAttr = function (baseKey, apply, container) {
    var layerFilter = {};
    layerFilter.baseKey = baseKey
    layerFilter.apply = apply;
    layerFilter.container = container;
    return layerFilter;
};


impactMAP.loadlayer = function (layerFilter) {
    impactMAP.map2totalcasesArr = [];
    impactMAP.geoJsonLayer = L.geoJson(impactMAP.geoJsonHolder, {
        filter: function (feature) {
            return impactMAP.filterLayer(feature, layerFilter);
        },
        style: impactMAP.setLayerStyle,
        onEachFeature: impactMAP.setLayerFeature
    });
    impactMAP.map.addLayer(impactMAP.geoJsonLayer);

    setTimeout(function () {

        impactMAP.map.fitBounds(impactMAP.geoJsonLayer.getBounds());
    }, 1500);


};

impactMAP.filterLayer = function (feature, layerFilter) {
    var returnFilter = true;
    if (layerFilter.apply) {
        var id = feature.properties[layerFilter.baseKey];
        returnFilter = impactMAP.idParser(layerFilter.container, id);
    }
    return returnFilter;
};

impactMAP.idParser = function (container, id) {
    var retCheck = false;
    for (var i in container) {
        if (container.hasOwnProperty(i)) {
            if (container[i] === id) {
                retCheck = true;
                break;
            }
        }
    }
    return retCheck;
};

impactMAP.setLayerStyle = function (feature) {
    //console.log(feature);
    var name = feature.properties.NAME_2;
    //console.log(name);
    if (name == undefined) {
        name = feature.properties.NAME_2;
    }

    var fillclr = impactMAP.getFeatureFillClr(impactMAP.getFeatureVal(name));

    //var classNam = 'highlight-' + fillclr.replace(new RegExp('#', 'g'), "");
    var classNam = '';

    if (impactMAP.filterCatApp) {
        impactMAP.setFilterCat(classNam, countryID)
    };
    return {
        color: '#FFF',
        weight: 0.8,
        opacity: 1,
        fillColor: fillclr,
        fillOpacity: 1,
        className: classNam
    };
};


impactMAP.getFeatureVal = function (id) {
    //alert("test");
    //ux.selectedStatename = "";
    //var name = id.toUpperCase();
    data = impactMAP.data({
        "5": {
            "isnocase": id
        }
    }).get();
    //    gdata = impactMAP.data().get();
    //    var data = getObjects(gdata, '5', id);
    console.log(id, data);

    //console.log(id);
    //console.log(map.stateName);
    // console.log(impactMAP.layoutConfig);
    //var returnVal = '#3ABA8B';
    var data = "";
    //    if (impactMAP.layoutConfig.userRole == 'NO' && (id == 'Kerala' || id == 'Maharashtra')) {
    if (impactMAP.layoutConfig.userRole == 'NO') {
        returnVal = '#d3e7ff'
            //returnVal = '#d3e7ff'
    } else {
        var returnVal = '#b3b3ff';
        data = impactMAP.data({
            "5": {
                "isnocase": id
            }
        }).get();
        //console.log(data.length);
    }

    var name = id;
    if (impactMAP.layoutConfig.userRole == 'NO') {
        var data = impactMAP.data({
            "5": {
                "isnocase": name
            }

        }).get();
        //console.log(data);
        $.each(data, function (i, e) {
            //console.log(i);
            //console.log(e.state); //SET USERNAME FROM HERE FOR DRILLDOWN AND GRAPHS
            //ux.selectedStatename = e.state;
        });
        //console.log(data.length);
        if (data.length > 10) {
            //console.log("higher");
            impactMAP.getFeatureFillClr('#D83C1A');
        }
    }


    if (data != undefined) {
        //console.log(data.length);
        //console.log(impactMAP.layoutConfig);
        if (impactMAP.layoutConfig.userRole == 'SO' && data.length == 0) {
            //            var returnVal = '#fee5d9';
            var returnVal = '#d3e7ff';
        }
    }

    if ($.isEmptyObject(data) == false) {
        // $.each(data, function (i, e) {
        returnVal = '#0349ba';
        //console.log(returnVal);
        //            if (e.district != '') {
        //                console.log(e.district);
        //                returnColor = '#000000';
        //            }

        // });
    }
    // returnColor = '#ffffff';
    return returnVal;
};

impactMAP.getFeatureFillClr = function (value) {

    var returnColor = '';
    returnColor = value;
    //console.log(value);
    if (typeof returnColor == 'undefined') {
        returnColor = '#EB2E17';
    }
    return returnColor;
};

impactMAP.setFilterCat = function (classNam, id) {
    if (!impactMAP.filterCat.hasOwnProperty(classNam)) {
        impactMAP.filterCat[classNam] = [];
    }
    impactMAP.filterCat[classNam].push(id);
};

impactMAP.removeLayer = function () {
    if (impactMAP.geoJsonLayer != undefined) {
        impactMAP.map.removeLayer(impactMAP.geoJsonLayer);
    }
};

impactMAP.setLayerFeature = function (feature, layer) {

    layer.on({
        mouseover: impactMAP.highlightFeature,
        mouseout: impactMAP.resetFeature
    });

    $(layer).click(function (e) {
        //console.log(e);
        var NAME_2 = e.target.feature.properties.DISTRICT;
        var stateName = e.target.feature.properties.NAME;

        //console.log(NAME_2);
        NAME_2 = NAME_2;
        var data = impactMAP.data({
            5: NAME_2
        }).get();
        //console.log(data);
        //console.log(data.length);

        var datanew = impactMAP.data({
            7: stateName

        }).get();
        //console.log(datanew);
        $.each(datanew, function (i, e) {
            //console.log(i);
            //console.log(e.state);
            ux.selectedStatename = e.state;
        });



    }).dblclick(function (e) {

        $(this).data('double', 2);
        //console.log(e.target.feature.properties);
        //console.log(e.target.feature.properties.ISO);
        //console.log(e.target.feature.properties.NAME);
        map.stateName = e.target.feature.properties.NAME;
        if (e.target.feature.properties.ISO == e.target.feature.properties.ISO) {
            e.target.unbindLabel();

            //console.log(ux.selectedStatename);
            uc.drillMapChangechartdata(ux.selectedStatename);
            MapDrilldown();

        }
    });

    layer.bindLabel(impactMAP.getLabelContent(layer), {
        dynamicBorderColor: 'rgba(240, 243, 246, 0.58)',
        direction: 'right',
        //offset:[6, -6],
        opacity: 0.9
            //noHide: true
    });
};

impactMAP.highlightFeature = function (e) {
    var layer = e.target;

    layer.setStyle({
        weight: 2,
        color: 'white',
        dashArray: '',
        fillOpacity: 0.8
    });


};

impactMAP.capitalizeFirstLetter = function (string) {
    //console.log(string);
    var name = string.charAt(0).toUpperCase() + string.slice(1);
    //console.log(name);
    return name;

}

impactMAP.map2totalcasesArr = [];
impactMAP.getLabelContent = function (layer) {

    var layerStyle = impactMAP.getLayerStyle(layer);
    //impactMAP.legendControlObj.highLightScale(layerStyle.className, layerStyle.fillColor, 'bold', '10px');
    impactMAP.labelBorderClr = layerStyle.fillColor;

    name1 = layer.feature.properties.NAME_2
        //console.log(name1);

    //    var name = layer.feature.properties.NAME;
    var name = layer.feature.properties.NAME_2;

    if (name == undefined) {
        name = layer.feature.properties.NAME_2
    }
    //console.log(name);
    impactMAP.capitalizeFirstLetter(name);
    //console.log(name);
    //name = name.toUpperCase();
    //console.log(layer.feature.properties.DISTRICT);

    if (impactMAP.layoutConfig.userRole == 'NO') {
        var data = impactMAP.data({

            "5": {
                "isnocase": name
            }
        }).get();
        //console.log(data.length);
        var len = Number(data.length)
        console.log(len);
        if (data.length > 1) {
            var sum = ""
            impactMAP.map2totalcasesArr.push(len);
            console.log(impactMAP.map2totalcasesArr);
            sum = impactMAP.map2totalcasesArr.reduce((x, y) => x + y);
            console.log(sum);
            impactMAP.sum = sum
                //console.log("higher");
            impactMAP.getFeatureFillClr('#D83C1A');
        }
    } else {

        var data = impactMAP.data({
            5: name

        }).get();
        //console.log(data.length);



    }
    //console.log(data.length);

    var html = '';

    // $.each(data, function (i, e) {
    //console.log(data);
    //console.log(data[0].district);
    //var dis=e.district;
    var count = data.length
        //console.log(count);
    var districtName = layer.feature.properties.NAME; //data.length != 0 ? data[0].district : layer.feature.properties.NAME;
    //console.log(districtName);
    if (districtName == undefined) {
        districtName = layer.feature.properties.NAME_2;
    }

    if (impactMAP.layoutConfig.userRole == 'NO') {
        // && districtName == 'Kerala') {
        //console.log(data.length);
        var districtCount = data.length != 0 ? data.length : 'No case found';

    } else {
        var districtCount = data.length != 0 ? data.length : 'No case found';
    }
    //console.log(districtCount);
    if (districtCount > 10) {
        //console.log(districtCount);
        impactMAP.getFeatureFillClr('#D83C1A');
    }

    html += '<div class="panel panel-info" style="z-index:9999 !important;">' +
        '<div class="panel-heading" style="background-color: #000; color:#fff;padding:0px 2px;"><h4 class="panel-title">' + "District : " + districtName + '</h4>' + '<br>' + "No. of cases : " + districtCount + '</div>' +
        '</div>';
    $("#totalcasedispyr2").html("  " + "      " + impactMAP.sum);

    var caseCountTemplate = "<span class='labelpopup'><h3>" + districtName + "</h3><hr><span>Number of Cases: " + districtCount + "</span></span>";
    html = caseCountTemplate; //impactMAP.buildHoverPopupHtml(districtName,caseCountTemplate);
    //console.log(html);
    return html;

    // });


    if ($.isEmptyObject(data) == false) {
        return html;
    }

};

impactMAP.buildHoverPopupHtml = function (header, data) {

    var html = '<div class="box box-primary box-solid box-transparent">' +
        '<div class="box-header" data-toggle="tooltip" title="" data-original-title="Header tooltip">' +
        '<h4 class="box-title" >' + header + '</h4>' +
        '</div>' +
        '<div class="box-body">' + data +
        '</div>' +
        '</div>';

    return html;
}


impactMAP.resetFeature = function (e) {
    var layerStyle = impactMAP.getLayerStyle(e.target);
    impactMAP.geoJsonLayer.resetStyle(e.target);
};


impactMAP.getLayerStyle = function (layer) {
    var layerStyleObj = {};
    if (layer.options != undefined) {
        layerStyleObj.className = layer.options.className;
        layerStyleObj.fillColor = layer.options.fillColor;
    } else {
        var getLeafletId = layer._leaflet_id;
        var ftrlayer = layer._layers;
        layerStyleObj.className = ftrlayer[getLeafletId - 1].options.className;
        layerStyleObj.fillColor = ftrlayer[getLeafletId - 1].options.fillColor;
    }
    //console.log(layerStyleObj);
    return layerStyleObj;
};

impactMAP.resetMap = function () {
    impactMAP.removeLayer();
    impactMAP.map.setView(new L.LatLng(impactMAP._lat, impactMAP._lng), impactMAP._zoom);
    impactMAP.loadWorldGeoJson();
};