var newDashboardMap = {};
newDashboardMap.data = '';
newDashboardMap.layoutConfig = null;


newDashboardMap.initialise = function () {

    //newDashboardMap.map.remove();
    //    newDashboardMap.map.off();

    var current_user = $.jStorage.get("userObject").userName;
    //console.log("USER....." + current_user);
    /* Constants */
    newDashboardMap.map = null;
    //newDashboardMap._lat = 19;
    // newDashboardMap._lng = 17;
    var D = "diouser";
    var S = "siouser";

    //console.log(newDashboardMap.getCurrentUserConfigLayout());

    if (current_user == "diouser1") {
        //console.log("I am Dio");
        newDashboardMap._lat = 10.8505;
        newDashboardMap._lng = 76.2711;
        newDashboardMap._zoom = 7;
    } else if (current_user == current_user) {
        //console.log("I am Sio");
        var current_userobj = $.jStorage.get("userObject");
        newDashboardMap._lat = Number(current_userobj.latitude);
        newDashboardMap._lng = Number(current_userobj.longitude);
        //console.log(newDashboardMap._lat);
        //console.log(newDashboardMap._lng);
        //        newDashboardMap._lat = 10.8505;
        //        newDashboardMap._lng = 76.2711;
        newDashboardMap._zoom = 5;
    } else {
        //console.log("I am Nio");
        newDashboardMap._lat = 22.9734;
        newDashboardMap._lng = 78.6569;
        newDashboardMap._zoom = 4;

    }


    newDashboardMap._minZoom = 4;
    newDashboardMap._maxZoom = 20;
    newDashboardMap.ggl;
    newDashboardMap.check = true;
    newDashboardMap.geoJsonLayer = null;
    newDashboardMap.geoJsonHolder = null;
    $(".provDistlevel").hide();
    newDashboardMap.initialiseMap(); // Initialise the map
    newDashboardMap.loadWorldGeoJson(); // Load world shape file
};





newDashboardMap.getCurrentUserConfigLayout = function () {
    // console.log("1");
    var current_user = $.jStorage.get("userObject");

    var config = {

        userRole: null,
        userName: null,
        countryName: null,
        stateName: null,
        districtName: null,
        shapeFileUrl: null
    };

    if (current_user.userRole === "DIO") {
        config.userRole = current_user.userRole;
        config.userName = current_user.userName;
        config.countryName = 'India';
        config.stateName = current_user.orgParentName;
        config.districtName = current_user.orgName;
        config.shapeFileUrl = './shapes/country/india/state/' + config.stateName.toLowerCase() + '/district/' + config.districtName.toLowerCase() + ".geojson";

    } else if (current_user.userRole === "SO") {
        config.userRole = current_user.userRole;
        config.userName = current_user.userName;
        config.countryName = current_user.orgParentName;
        config.stateName = current_user.orgName;
        //console.log(config.stateName);
        config.districtName = null;
        config.shapeFileUrl = './shapes/country/india/state/' + config.stateName.toLowerCase() + '/' + config.stateName.toLowerCase() + ".geojson";

        map.stateName = current_user.orgName;
        map.shapeFileUrl = './shapes/country/india/state/' + config.stateName.toLowerCase() + '/' + config.stateName.toLowerCase() + ".geojson";

    } else if (current_user.userRole === "NO") {
        config.userRole = current_user.userRole;
        config.userName = current_user.userName;
        config.countryName = current_user.orgName;
        config.stateName = null;
        config.districtName = null;
        config.shapeFileUrl = './shapes/country/india/District.geojson';
    }

    return config;
}



// Initialise the map
newDashboardMap.initialiseMap = function () {
    newDashboardMap.map = null;
    $("#impactPreventionMapC").empty();

    newDashboardMap.map = new L.Map('impactPreventionMapC', {
        attributionControl: false,
        center: new L.LatLng(newDashboardMap._lat, newDashboardMap._lng),
        zoom: newDashboardMap._zoom,
        minZoom: newDashboardMap._minZoom,
        maxZoom: newDashboardMap._maxZoom,
        doubleClickZoom: false,
        scrollWheelZoom: false,
        zoomControl: false
    });

    //newDashboardMap.loadMapTiles(); // Load map tiles
    //    newDashboardMap.initialiseMapMenuControl(); // Re-initialise map controls after adding on map
    //ADD RESET BUTTON 
    (function () {
        var control = new L.Control({
            position: 'topright'
        });
        control.onAdd = function (map) {
            var azoom = L.DomUtil.create('a', 'resetzoom');
            azoom.innerHTML = "<button id='resetbtn'>Back</button>";
            L.DomEvent
                .disableClickPropagation(azoom)
                .addListener(azoom, 'click', function () {
                    MapDrillUp();
                    //                    console.log("test1");
                    uc.loadRealTimeMapChart();
                    //newDashboardMap.resetMap();
                    map.setView(map.options.center, map.options.zoom);
                }, azoom);
            return azoom;
        };
        return control;
    }())
    .addTo(newDashboardMap.map);

    //ADD LEGEND CONTROL
    function getColor(d) {
        return d > 1000 ? '#800026' :
            d > 500 ? '#BD0026' :
            d > 200 ? '#E31A1C' :
            d > 100 ? '#FC4E2A' :
            d > 50 ? '#FD8D3C' :
            d > 20 ? '#FEB24C' :
            d > 10 ? '#FED976' :
            '#FFEDA0';
    }


    var legend = L.control({
        position: 'bottomright'
    });

    legend.onAdd = function (map) {

        var div = L.DomUtil.create('div', 'info legend'),
            grades = [0, 10, 20, 50, 100, 200, 500, 1000],
            labels = [];

        // loop through our density intervals and generate a label with a colored square for each interval
        div.innerHTML += '<h4> No data ' + ' - ' + ' <div style=" float: right;width: 20px;height: 20px;margin: 1px; border: 1px solid rgba(0, 0, 0, .2);background: #d3e7ff;"></div></h4>'
        for (var i = 0; i < grades.length; i++) {

            // div.innerHTML += '<i style="background:' + getColor(grades[i] + 1) + '"></i> ' +
            //  grades[i] + (grades[i + 1] ? '&ndash;' + grades[i + 1] + '<br>' : '+');

        }

        return div;
    };

    legend.addTo(newDashboardMap.map);
    //END ADD LEGEND CONTROL


    new L.Control.Zoom({
        position: 'bottomright'
    }).addTo(newDashboardMap.map);
};

// Load map tiles
newDashboardMap.loadMapTiles = function () {
    // Google Layer
    newDashboardMap.ggl = new L.Google();

    newDashboardMap.baseMaps = {
        "Google Maps": newDashboardMap.ggl
    };

    newDashboardMap.map.addLayer(newDashboardMap.ggl);
    newDashboardMap.map.invalidateSize();
};

newDashboardMap.applyStateborder = function () {
    var dureNational = {};
    var countryShapeWholeFilePath = './shapes/country/india/IND.geojson';
    $.getJSON(countryShapeWholeFilePath, function (geoJsondata) {

        if (geoJsondata != undefined) {
            dureNational.geoJsonWholeHoldernew = geoJsondata;
            //console.log(dureNational.geoJsonWholeHoldernew);

            dureNational.geoJsonWholeLayer1 = L.geoJson(dureNational.geoJsonWholeHoldernew, {
                filter: '',
                style: {
                    color: '#003da0',
                    weight: 0.6,
                    opacity: 1,
                    fillColor: '',
                    fillOpacity: 0
                },
                onEachFeature: ''
            });
            //console.log(dureNational.geoJsonWholeLayer1);
            newDashboardMap.map.addLayer(dureNational.geoJsonWholeLayer1); //test load layer
        }
    }).error();


}


// Get World GEOJSON shape file
newDashboardMap.loadWorldGeoJson = function () {

    if (newDashboardMap.geoJsonHolder == undefined) {

        newDashboardMap.layoutConfig = newDashboardMap.getCurrentUserConfigLayout();
        var shapeFilePath = newDashboardMap.layoutConfig.shapeFileUrl
            //console.log(shapeFilePath);
        $.getJSON(shapeFilePath, function (geoJsondata) {
            if (geoJsondata != undefined) {
                newDashboardMap.geoJsonHolder = geoJsondata;
                if (newDashboardMap.map == undefined) {
                    newDashboardMap.initialiseMap();
                }
                newDashboardMap.applyStateborder();
                newDashboardMap.showIndicatorDataOnMap();
                $('#loading').hide();
            }
        }).error(function (jqXHR, textStatus, errorThrown) {

            console.log(jqXHR);
            console.log(textStatus);
            console.log(errorThrown);
        });
    } else {
        newDashboardMap.showIndicatorDataOnMap();
        $('#loading').hide();
    }
};

newDashboardMap.showIndicatorDataOnMap = function () {
    var layerFilter = newDashboardMap.filterAttr('iso_a2', false, []);
    newDashboardMap.loadlayer(layerFilter);
    //console.log(layerFilter);
    //alert("show indicator")
};

newDashboardMap.filterAttr = function (baseKey, apply, container) {
    var layerFilter = {};
    layerFilter.baseKey = baseKey
    layerFilter.apply = apply;
    layerFilter.container = container;
    return layerFilter;
};


newDashboardMap.loadlayer = function (layerFilter) {
    newDashboardMap.map2totalcasesArr = [];
    newDashboardMap.geoJsonLayer = L.geoJson(newDashboardMap.geoJsonHolder, {
        filter: function (feature) {
            return newDashboardMap.filterLayer(feature, layerFilter);
        },
        style: newDashboardMap.setLayerStyle,
        onEachFeature: newDashboardMap.setLayerFeature
    });
    newDashboardMap.map.addLayer(newDashboardMap.geoJsonLayer);

    setTimeout(function () {

        newDashboardMap.map.fitBounds(newDashboardMap.geoJsonLayer.getBounds());
    }, 1500);


};

newDashboardMap.filterLayer = function (feature, layerFilter) {
    var returnFilter = true;
    if (layerFilter.apply) {
        var id = feature.properties[layerFilter.baseKey];
        returnFilter = newDashboardMap.idParser(layerFilter.container, id);
    }
    return returnFilter;
};

newDashboardMap.idParser = function (container, id) {
    var retCheck = false;
    for (var i in container) {
        if (container.hasOwnProperty(i)) {
            if (container[i] === id) {
                retCheck = true;
                break;
            }
        }
    }
    return retCheck;
};

newDashboardMap.setLayerStyle = function (feature) {
    //console.log(feature);
    var name = feature.properties.NAME_2;
    //console.log(name);
    if (name == undefined) {
        name = feature.properties.NAME_2;
    }

    var fillclr = newDashboardMap.getFeatureFillClr(newDashboardMap.getFeatureVal(name));

    //var classNam = 'highlight-' + fillclr.replace(new RegExp('#', 'g'), "");
    var classNam = '';

    if (newDashboardMap.filterCatApp) {
        newDashboardMap.setFilterCat(classNam, countryID)
    };
    return {
        color: '#FFF',
        weight: 0.8,
        opacity: 1,
        fillColor: fillclr,
        fillOpacity: 1,
        className: classNam
    };
};


newDashboardMap.getFeatureVal = function (id) {
    //alert("test");
    //ux.selectedStatename = "";
    //var name = id.toUpperCase();
    data = newDashboardMap.data({
        "5": {
            "isnocase": id
        }
    }).get();
    //    gdata = newDashboardMap.data().get();
    //    var data = getObjects(gdata, '5', id);
    console.log(id, data);

    //console.log(id);
    //console.log(map.stateName);
    // console.log(newDashboardMap.layoutConfig);
    //var returnVal = '#3ABA8B';
    var data = "";
    //    if (newDashboardMap.layoutConfig.userRole == 'NO' && (id == 'Kerala' || id == 'Maharashtra')) {
    if (newDashboardMap.layoutConfig.userRole == 'NO') {
        returnVal = '#d3e7ff'
            //returnVal = '#d3e7ff'
    } else {
        var returnVal = '#b3b3ff';
        data = newDashboardMap.data({
            "5": {
                "isnocase": id
            }
        }).get();
        //console.log(data.length);
    }

    var name = id;
    if (newDashboardMap.layoutConfig.userRole == 'NO') {
        var data = newDashboardMap.data({
            "5": {
                "isnocase": name
            }

        }).get();
        //console.log(data);
        $.each(data, function (i, e) {
            //console.log(i);
            //console.log(e.state); //SET USERNAME FROM HERE FOR DRILLDOWN AND GRAPHS
            //ux.selectedStatename = e.state;
        });
        //console.log(data.length);
        if (data.length > 10) {
            //console.log("higher");
            newDashboardMap.getFeatureFillClr('#D83C1A');
        }
    }


    if (data != undefined) {
        //console.log(data.length);
        //console.log(newDashboardMap.layoutConfig);
        if (newDashboardMap.layoutConfig.userRole == 'SO' && data.length == 0) {
            //            var returnVal = '#fee5d9';
            var returnVal = '#d3e7ff';
        }
    }

    if ($.isEmptyObject(data) == false) {
        // $.each(data, function (i, e) {
        returnVal = '#0349ba';
        //console.log(returnVal);
        //            if (e.district != '') {
        //                console.log(e.district);
        //                returnColor = '#000000';
        //            }

        // });
    }
    // returnColor = '#ffffff';
    return returnVal;
};

newDashboardMap.getFeatureFillClr = function (value) {

    var returnColor = '';
    returnColor = value;
    //console.log(value);
    if (typeof returnColor == 'undefined') {
        returnColor = '#EB2E17';
    }
    return returnColor;
};

newDashboardMap.setFilterCat = function (classNam, id) {
    if (!newDashboardMap.filterCat.hasOwnProperty(classNam)) {
        newDashboardMap.filterCat[classNam] = [];
    }
    newDashboardMap.filterCat[classNam].push(id);
};

newDashboardMap.removeLayer = function () {
    if (newDashboardMap.geoJsonLayer != undefined) {
        newDashboardMap.map.removeLayer(newDashboardMap.geoJsonLayer);
    }
};

newDashboardMap.setLayerFeature = function (feature, layer) {

    layer.on({
        mouseover: newDashboardMap.highlightFeature,
        mouseout: newDashboardMap.resetFeature
    });

    $(layer).click(function (e) {
        //console.log(e);
        var NAME_2 = e.target.feature.properties.DISTRICT;
        var stateName = e.target.feature.properties.NAME;

        //console.log(NAME_2);
        NAME_2 = NAME_2;
        var data = newDashboardMap.data({
            5: NAME_2
        }).get();
        //console.log(data);
        //console.log(data.length);

        var datanew = newDashboardMap.data({
            7: stateName

        }).get();
        //console.log(datanew);
        $.each(datanew, function (i, e) {
            //console.log(i);
            //console.log(e.state);
            ux.selectedStatename = e.state;
        });



    }).dblclick(function (e) {

        $(this).data('double', 2);
        //console.log(e.target.feature.properties);
        //console.log(e.target.feature.properties.ISO);
        //console.log(e.target.feature.properties.NAME);
        map.stateName = e.target.feature.properties.NAME;
        if (e.target.feature.properties.ISO == e.target.feature.properties.ISO) {
            e.target.unbindLabel();

            //console.log(ux.selectedStatename);
            uc.drillMapChangechartdata(ux.selectedStatename);
            MapDrilldown();

        }
    });

    layer.bindLabel(newDashboardMap.getLabelContent(layer), {
        dynamicBorderColor: 'rgba(240, 243, 246, 0.58)',
        direction: 'right',
        //offset:[6, -6],
        opacity: 0.9
            //noHide: true
    });
};

newDashboardMap.highlightFeature = function (e) {
    var layer = e.target;

    layer.setStyle({
        weight: 2,
        color: 'white',
        dashArray: '',
        fillOpacity: 0.8
    });


};

newDashboardMap.capitalizeFirstLetter = function (string) {
    //console.log(string);
    var name = string.charAt(0).toUpperCase() + string.slice(1);
    //console.log(name);
    return name;

}

newDashboardMap.map2totalcasesArr = [];
newDashboardMap.getLabelContent = function (layer) {

    var layerStyle = newDashboardMap.getLayerStyle(layer);
    //newDashboardMap.legendControlObj.highLightScale(layerStyle.className, layerStyle.fillColor, 'bold', '10px');
    newDashboardMap.labelBorderClr = layerStyle.fillColor;

    name1 = layer.feature.properties.NAME_2
        //console.log(name1);

    //    var name = layer.feature.properties.NAME;
    var name = layer.feature.properties.NAME_2;

    if (name == undefined) {
        name = layer.feature.properties.NAME_2
    }
    //console.log(name);
    newDashboardMap.capitalizeFirstLetter(name);
    //console.log(name);
    //name = name.toUpperCase();
    //console.log(layer.feature.properties.DISTRICT);

    if (newDashboardMap.layoutConfig.userRole == 'NO') {
        var data = newDashboardMap.data({

            "5": {
                "isnocase": name
            }
        }).get();
        //console.log(data.length);
        var len = Number(data.length)
        console.log(len);
        if (data.length > 1) {
            var sum = ""
            newDashboardMap.map2totalcasesArr.push(len);
            console.log(newDashboardMap.map2totalcasesArr);
            sum = newDashboardMap.map2totalcasesArr.reduce((x, y) => x + y);
            console.log(sum);
            newDashboardMap.sum = sum
                //console.log("higher");
            newDashboardMap.getFeatureFillClr('#D83C1A');
        }
    } else {

        var data = newDashboardMap.data({
            5: name

        }).get();
        //console.log(data.length);



    }
    //console.log(data.length);

    var html = '';

    // $.each(data, function (i, e) {
    //console.log(data);
    //console.log(data[0].district);
    //var dis=e.district;
    var count = data.length
        //console.log(count);
    var districtName = layer.feature.properties.NAME; //data.length != 0 ? data[0].district : layer.feature.properties.NAME;
    //console.log(districtName);
    if (districtName == undefined) {
        districtName = layer.feature.properties.NAME_2;
    }

    if (newDashboardMap.layoutConfig.userRole == 'NO') {
        // && districtName == 'Kerala') {
        //console.log(data.length);
        var districtCount = data.length != 0 ? data.length : 'No case found';

    } else {
        var districtCount = data.length != 0 ? data.length : 'No case found';
    }
    //console.log(districtCount);
    if (districtCount > 10) {
        //console.log(districtCount);
        newDashboardMap.getFeatureFillClr('#D83C1A');
    }

    html += '<div class="panel panel-info" style="z-index:9999 !important;">' +
        '<div class="panel-heading" style="background-color: #000; color:#fff;padding:0px 2px;"><h4 class="panel-title">' + "District : " + districtName + '</h4>' + '<br>' + "No. of cases : " + districtCount + '</div>' +
        '</div>';
    $("#totalcasedispyr3").html("  " + "      " + newDashboardMap.sum);

    var caseCountTemplate = "<span class='labelpopup'><h3>" + districtName + "</h3><hr><span>Number of Cases: " + districtCount + "</span></span>";
    html = caseCountTemplate; //newDashboardMap.buildHoverPopupHtml(districtName,caseCountTemplate);
    //console.log(html);
    return html;

    // });


    if ($.isEmptyObject(data) == false) {
        return html;
    }

};

newDashboardMap.buildHoverPopupHtml = function (header, data) {

    var html = '<div class="box box-primary box-solid box-transparent">' +
        '<div class="box-header" data-toggle="tooltip" title="" data-original-title="Header tooltip">' +
        '<h4 class="box-title" >' + header + '</h4>' +
        '</div>' +
        '<div class="box-body">' + data +
        '</div>' +
        '</div>';

    return html;
}


newDashboardMap.resetFeature = function (e) {
    var layerStyle = newDashboardMap.getLayerStyle(e.target);
    newDashboardMap.geoJsonLayer.resetStyle(e.target);
};


newDashboardMap.getLayerStyle = function (layer) {
    var layerStyleObj = {};
    if (layer.options != undefined) {
        layerStyleObj.className = layer.options.className;
        layerStyleObj.fillColor = layer.options.fillColor;
    } else {
        var getLeafletId = layer._leaflet_id;
        var ftrlayer = layer._layers;
        layerStyleObj.className = ftrlayer[getLeafletId - 1].options.className;
        layerStyleObj.fillColor = ftrlayer[getLeafletId - 1].options.fillColor;
    }
    //console.log(layerStyleObj);
    return layerStyleObj;
};

newDashboardMap.resetMap = function () {
    newDashboardMap.removeLayer();
    newDashboardMap.map.setView(new L.LatLng(newDashboardMap._lat, newDashboardMap._lng), newDashboardMap._zoom);
    newDashboardMap.loadWorldGeoJson();
};