var nmMAP = {};
nmMAP.map = null;
nmMAP.markers = new L.FeatureGroup();
nmMAP.markerIDMAP = {};
nmMAP.popups = [];
nmMAP.casepopup = [];
var RedIcon = L.Icon.Default.extend({
    options: {
        iconUrl: 'img/marker-icon-red.png'
    }
});
var redIcon = new RedIcon();


nmMAP.init = function () {
    //var currentLocation = $.jStorage.get("currentLocation");
    currentLat = $.jStorage.get("current_lat");
    currentLon = $.jStorage.get("current_lng");

    if (nmMAP.map == null) {
        nmMAP.map = new L.Map('nmmap', {
            center: new L.LatLng(currentLat, currentLon),
            //center: new L.LatLng(26.5727, 73.8390),
            zoom: 12,
            maxBounds: [[90, -180], [-90, 180]],
            zoomControl: false,
            fullscreenControl: true,
            fullscreenControlOptions: {
                position: 'topright'
            }
        });

        var zoomControl = L.control.zoom({
            position: 'topright'
        });
        nmMAP.map.addControl(zoomControl);
    }



    if (navigator.onLine) {
        var ggl = new L.Google();
        nmMAP.map.addLayer(ggl);

        google.maps.event.addListenerOnce(nmMAP.map, 'idle', function () {
            google.maps.event.trigger(nmMAP.map, 'resize');
        });
    }

//    setTimeout(function () {
//        nmMAP.map.invalidateSize();
//        nmMAP.map.setView([currentLat, currentLon], 2)
//    }, 1000);

};


nmMAP.resetMAP = function () {
    nmMAP.markers.clearLayers();
    nmMAP.map.removeLayer(nmMAP.markers);
    nmMAP.markers = new L.FeatureGroup();
};



nmMAP.markerView = function (r) {

    nmMAP.resetMAP();
    var latLngList = [];

    var currentLocation = $.jStorage.get('currentLocation');

    var defaultMarker = L.marker([currentLat, currentLon], {
        icon: redIcon
    });

    defaultMarker.bindPopup("You are here", {
        showOnMouseOver: true
    });

    nmMAP.markers.addLayer(defaultMarker);
    nmMAP.map.addLayer(nmMAP.markers);

    latLngList.push(new L.latLng(currentLat, currentLon));


    if (r) {

        var facilityList = [];

        $(r).each(function (i, e) {

            facilityList.push(e.facilityName);


            if (typeof e.latitude != undefined && typeof e.longitude != undefined) {
                latLngList.push(new L.latLng(e.latitude, e.longitude));

                if ($.jStorage.get("searchKeyword") !== 'null' && $.jStorage.get("searchKeyword") !== null &&
                    $.jStorage.get("searchKeyword") !== 'select') {

                    if ($.jStorage.get("searchKeyword") === e.facilityName) {
                        nmMAP.buildMarker(e);

                    }
                } else {
                    nmMAP.buildMarker(e);
                }
            }
        });


        $.unique(facilityList);
        $("#facility").empty();

        $('#facility').append($('<option></option>').val('select').html("Select Facility"));
        $(facilityList).each(function (i, e) {
            var selected = '';
            if ($.jStorage.get("searchKeyword") === e) {
                selected = "selected";
            }

            $('#facility').append($('<option ' + selected + '></option>').val(e).html(e));
        });


        nmMAP.map.on('popupopen', function (e) {

            var px = nmMAP.map.project(e.popup._latlng);
            px.y -= e.popup._container.clientHeight / 2;
            nmMAP.map.panTo(nmMAP.map.unproject(px), {
                animate: true
            });

        });

        nmMAP.map.addLayer(nmMAP.markers);


        if (latLngList.length > 0) {

            nmMAP.map.fitBounds(new L.latLngBounds(latLngList), {
                padding: [100, 100]
            });
        }
    }
};




nmMAP.buildMarker = function (e) {

    var marker;
    if (!$.isEmptyObject(e.markerstyle)) {
        marker = L.marker([e.latitude, e.longitude], {
            icon: L.AwesomeMarkers.icon(nmMAP.markerType(e.markerstyle))
        });
    } else {
        marker = L.marker([e.latitude, e.longitude]);
    }

    $.get('application/templates/nearmepopup.html', function (data) {
        var compiled = Template7.compile(data);
        var html = compiled(e);
        marker.bindPopup(html, {
            showOnMouseOver: true
        });
        nmMAP.markers.addLayer(marker);

    });
};



nmMAP.markerType = function (markerstyle) {

    var fontMarker = {};
    var icon = 'map-marker';
    var markercolor = 'blue';

    if (markerstyle.icon !== undefined || markerstyle.icon !== 'undefined') {
        icon = markerstyle.icon;
    }
    if (markerstyle.color !== undefined || markerstyle.color !== 'undefined') {
        markercolor = markerstyle.color;
    }
    fontMarker.icon = icon;
    fontMarker.prefix = "fa";
    fontMarker.markerColor = markercolor;
    return fontMarker;
};




nmMAP.checkoutNearme = function (facility) {
    if (facility == '') {
        $.jStorage.set("searchKeyword", 'null');
    } else {
        $.jStorage.set("searchKeyword", facility);
        uc.nearMe();
    }

};

nmMAP.resetMAP = function () {
    nmMAP.markers.clearLayers();
    nmMAP.map.removeLayer(nmMAP.markers);
    nmMAP.markers = new L.FeatureGroup();
};